/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Privileges;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;

public class Schema
extends Statement {
    String type;
    String schema_name;

    public void prepare() throws DatabaseException {
        this.type = (String)this.cmd.getObject("type");
        this.schema_name = (String)this.cmd.getObject("schema_name");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        String com = this.type.toLowerCase();
        if (!this.database.getDatabase().canUserCreateAndDropSchema(context, this.user, this.schema_name)) {
            throw new UserAccessException("User not permitted to create or drop schema.");
        }
        if (com.equals("create")) {
            boolean ignore_case = this.database.isInCaseInsensitiveMode();
            SchemaDef schema = this.database.resolveSchemaCase(this.schema_name, ignore_case);
            if (schema != null) throw new DatabaseException("Schema '" + this.schema_name + "' already exists.");
            this.database.createSchema(this.schema_name, "USER");
            this.database.getGrantManager().addGrant(Privileges.SCHEMA_ALL_PRIVS, 65, this.schema_name, this.user.getUserName(), true, "@SYSTEM");
            return FunctionTable.resultTable(context, 0);
        } else {
            if (!com.equals("drop")) throw new DatabaseException("Unrecognised schema command.");
            boolean ignore_case = this.database.isInCaseInsensitiveMode();
            SchemaDef schema = this.database.resolveSchemaCase(this.schema_name, ignore_case);
            if (schema == null) {
                throw new DatabaseException("Schema '" + this.schema_name + "' does not exist.");
            }
            if (!schema.getType().equals("USER")) throw new DatabaseException("Can not drop schema '" + this.schema_name + "'");
            TableName[] all_tables = this.database.getTableList();
            String resolved_schema_name = schema.getName();
            for (int i = 0; i < all_tables.length; ++i) {
                if (!all_tables[i].getSchema().equals(resolved_schema_name)) continue;
                throw new DatabaseException("Schema '" + this.schema_name + "' is not empty.");
            }
            this.database.dropSchema(schema.getName());
            this.database.getGrantManager().revokeAllGrantsOnObject(65, schema.getName());
        }
        return FunctionTable.resultTable(context, 0);
    }
}

